;(() => {
  function selectA() {
    let t = document.querySelector('.globaltoc')
    if (!t) return
    
    // 根据当前URL找到对应的导航项
    function findCurrentNavItem() {
      // 获取当前页面的完整URL（包括哈希）
      let currentFullURL = window.location.href
      // 获取当前页面的路径（不带哈希）
      let currentPath = window.location.pathname
      // 获取哈希部分
      let currentHash = window.location.hash
      
      // 查找所有导航链接
      let allLinks = t.querySelectorAll('a')
      let currentLink = null
      
      // 先尝试完整匹配（包括哈希）
      allLinks.forEach(link => {
        let href = link.getAttribute('href')
        if (href && (currentFullURL.endsWith(href) || href === currentHash)) {
          currentLink = link
        }
      })
      
      // 如果完整匹配失败，尝试匹配路径部分
      if (!currentLink) {
        allLinks.forEach(link => {
          let href = link.getAttribute('href')
          if (href && href.split('#')[0] === currentPath.split('#')[0]) {
            currentLink = link
          }
        })
      }
      
      // 如果路径匹配也失败，尝试部分匹配
      if (!currentLink) {
        let pathSegments = currentPath.split('/').filter(seg => seg)
        allLinks.forEach(link => {
          let href = link.getAttribute('href')
          if (href) {
            let hrefPath = href.split('#')[0]
            let hrefSegments = hrefPath.split('/').filter(seg => seg)
            // 检查是否有足够的匹配段
            let matchCount = 0
            for (let i = 0; i < Math.min(pathSegments.length, hrefSegments.length); i++) {
              if (pathSegments[i] === hrefSegments[i]) {
                matchCount++
              } else {
                break
              }
            }
            // 如果匹配度超过50%，认为是当前页面
            if (matchCount > 0 && matchCount >= Math.min(pathSegments.length, hrefSegments.length) / 2) {
              currentLink = link
            }
          }
        })
      }
      
      return currentLink
    }
    
    // 滚动到哈希锚点
    function scrollToHash() {
      let hash = window.location.hash
      if (hash) {
        // 等待页面完全加载
        setTimeout(() => {
          let target = document.querySelector(hash)
          if (target) {
            // 计算偏移量，考虑固定导航栏
            let offset = 80
            let targetPosition = target.getBoundingClientRect().top + window.pageYOffset - offset
            
            window.scrollTo({
              top: targetPosition,
              behavior: 'smooth'
            })
          }
        }, 500)
      }
    }
    
    // 设置当前导航项
    function setCurrentNav() {
      let currentLink = findCurrentNavItem()
      
      if (currentLink) {
        // 移除所有current类和active类
        document.querySelectorAll('.globaltoc .current, .globaltoc .active').forEach(el => {
          el.classList.remove('current', 'active')
        })
        
        // 设置当前链接为选中状态
        let currentLi = currentLink.closest('li')
        if (currentLi) {
          currentLi.classList.add('current', 'active')
          currentLink.classList.add('current', 'active')
          
          // 确保父级菜单也是展开状态
          let parentUl = currentLi.closest('ul')
          while (parentUl && parentUl !== t) {
            let parentLi = parentUl.closest('li')
            if (parentLi) {
              parentLi.classList.add('_expand')
              parentLi.classList.remove('_collapse')
              parentUl = parentLi.closest('ul')
            } else {
              break
            }
          }
        }
      }
      
      // 滚动到哈希锚点
      scrollToHash()
    }
    
    // 处理链接点击
    function handleMenuClick(clickedA) {
      // 移除所有current类和active类
      document.querySelectorAll('.globaltoc .current, .globaltoc .active').forEach(el => {
        el.classList.remove('current', 'active')
      })
      
      // 为当前点击的元素添加current和active类
      let currentLi = clickedA.closest('li')
      if (currentLi) {
        currentLi.classList.add('active')
        clickedA.classList.add('active')
      }
    }
    
    // 使用事件委托处理点击
    t.addEventListener('click', function (e) {
      // 只处理链接点击
      if (e.target.tagName === 'A' && e.target.getAttribute('href') !== '#') {
        let href = e.target.getAttribute('href')
        
        // 如果是页面内锚点链接
        if (href.startsWith('#')) {
          e.preventDefault()
          handleMenuClick(e.target)
          
          // 滚动到锚点
          let target = document.querySelector(href)
          if (target) {
            let offset = 80
            let targetPosition = target.getBoundingClientRect().top + window.pageYOffset - offset
            
            window.scrollTo({
              top: targetPosition,
              behavior: 'smooth'
            })
            
            // 更新URL哈希（不刷新页面）
            history.pushState(null, null, href)
          }
        } else {
          // 普通页面链接
          handleMenuClick(e.target)
        }
      }
    })
    
    // 监听哈希变化
    window.addEventListener('hashchange', function() {
      setTimeout(() => {
        setCurrentNav()
      }, 100)
    })
    
    // 页面加载时设置选中状态
    setTimeout(() => {
      setCurrentNav()
    }, 300)
  }
  
  if (document.readyState === 'loading') {
    // 此代码是为了解决点击二级时，会有事件默认选中前言，导致current显示错误
    document.addEventListener('DOMContentLoaded', selectA)
  } else {
    selectA()
  }
})()